#!/bin/bash

modprobe usbmon

if [ "$?" = "1" ]; then
    echo "Unable to load usbmon.ko"
    exit 1
fi

logdest=/var/log/usbmon
rm -rf $logdest
mkdir -p $logdest

cat /sys/kernel/debug/usb/devices > $logdest/sys-kernel-debug-usb-devices.log

# Trap EXIT pseudo-signal to make sure to kill all background processes on exit.
trap "trap - SIGKILL && kill -- -$$; modprobe -r usbmon" EXIT

while true; do
    
    curtime=$(date "+%Y-%m-%d_%H_%M_%S")
    curfile=$logdest/monitor_$curtime.log

    # "0u": Monitor all USB busses
    cat /sys/kernel/debug/usb/usbmon/0u > $curfile 2>/dev/null &
    
    pid=$!

    while [ "$(wc -c < $curfile)" -lt "$((2*1024*1024))" ]; do
        sleep 5
    done

    # Keep the two youngest log files.
    if [ $(ls $logdest/monitor_* | wc -l) -gt 2 ]; then
        rm $(ls $logdest/monitor_* | head -n 1)
    fi

    kill $pid

done
